Test_Categories = class()

function Test_Categories:init()
    self.title = "categories"
    self.hasCustomControls = true
end

function Test_Categories:setup()  
    self.lab = PhysicsLab()
    self.petrieDish = self.lab:makePetrieDish()   
    self.boxes = {}
    self.circles = {}
    self.triangles = {}    
    
    self:makeBodies()  
    
    self.lab.categoryManager:putIn("petrieDish category", self.petrieDish)
    self.lab.categoryManager:putTheseIn("box category", self.boxes)
    self.lab.categoryManager:putTheseIn("circle category", self.circles)
    self.lab.categoryManager:putTheseIn("triangle category", self.triangles)
    
    self:setupParameterControls()
    self:setSelected(self.boxes[1])
    self:setDefaultDetections()
    self:printInfo()
end

function Test_Categories:makeBodies()   
    
    local baseSize = WIDTH * 0.12
    local startX = (WIDTH/2) - (baseSize)
    local startY = (HEIGHT*0.33)
    local circleY = startY + (baseSize * 1.75) 
    local triangleY = startY + (baseSize * 3.5) 
    local pointDistance = baseSize * 0.5
    
    for i=1, 2 do        
        local currentX = startX + ((i - 1) * baseSize * 1.75) 
        
        local newBox = self.lab:boxAt(currentX, startY, baseSize, baseSize)
        local newCircle = self.lab:circleAt(currentX, circleY, baseSize * 0.6)
        local newTriangle = self.lab:polygonAt(currentX, triangleY, {vec2(0, pointDistance), vec2(-pointDistance,-pointDistance), vec2(pointDistance, -pointDistance)})
        
        newBox.name = "box"..i
        newCircle.name = "circle"..i
        newTriangle.name = "triangle"..i
        
        table.insert(self.boxes, newBox)
        table.insert(self.circles, newCircle)
        table.insert(self.triangles, newTriangle)
    end
end

function Test_Categories:printInfo()
    print("Shapes only collide if they detect each other's categories.  PhysicsLab uses named categories and the functions putIn(_), takeOutOf(_), makeDetect(_), and makeIgnore(_) to manage this.\n\nSelect any shape to adjust its categories.")

end

function Test_Categories:setupParameterControls()
    
    parameter.watch("nameOfSelected")    
    
    parameter.boolean("detectsCircles", false, function(value)
        if selectedBody then
            if value then
                self.lab.categoryManager:makeDetect("circle category", selectedBody)
            else
                self.lab.categoryManager:makeIgnore("circle category", selectedBody)
            end
        end
    end)
    
    parameter.boolean("detectsBoxes", false, function(value)
        if selectedBody then
            if value then
                self.lab.categoryManager:makeDetect("box category", selectedBody)
            else
                self.lab.categoryManager:makeIgnore("box category", selectedBody)
            end
        end
    end)
    
    parameter.boolean("detectsTriangles", false, function(value)
        if selectedBody then
            if value then
                self.lab.categoryManager:makeDetect("triangle category", selectedBody)
            else
                self.lab.categoryManager:makeIgnore("triangle category", selectedBody)
            end
        end
    end)
    
    parameter.action("reset all detections", function() self:setDefaultDetections() end)
end

function Test_Categories:setDefaultDetections()
    self.lab.categoryManager:makeBodiesDetectOnly({"petrieDish category", "box category", "triangle category"}, self.boxes)
    self.lab.categoryManager:makeBodiesDetectOnly({"petrieDish category", "box category", "triangle category"}, self.circles) 
    self.lab.categoryManager:makeBodiesDetectOnly({"petrieDish category", "box category", "circle category"}, self.triangles)
    self:setSelected(selectedBody)
end

function Test_Categories:setSelected(body)
    selectedBody = body
    nameOfSelected = selectedBody.name
    detectsBoxes = self.lab.categoryManager:verifyBodyDetects("box category", body)
    detectsCircles = self.lab.categoryManager:verifyBodyDetects("circle category", body)
    detectsTriangles = self.lab.categoryManager:verifyBodyDetects("triangle category", body)
end

function Test_Categories:draw()
    self.lab:draw()
    self.title = "categories (selected body:  "..nameOfSelected..")"
end

function Test_Categories:touched(touch)
    self.lab:touched(touch)
    if touch.state == BEGAN or touch.state == MOVING then
        if isTracking then return end
        for i,body in ipairs(self.lab.bodies) do
            if body ~= self.petrieDish and body:testPoint(touch.pos) then
                isTracking = true
                self:setSelected(body)
                return 
            end
        end
    else 
        isTracking = false
    end
end

function Test_Categories:collide(contact)
    self.lab:collide(contact)
end

function Test_Categories:cleanup()
    self.lab:clear()
    selectedBody = nil
    nameOfSelected = nil
    detectsBoxes = nil
    detectsCircles = nil
    detectsTriangles = nil
    isTracking = nil
end
